<!-- <nav> -->
- [Akka](index.html)
- [Welcome to Akka](index.html)

<!-- </nav> -->

# Welcome to Akka

Akka is a platform for building, running and evaluating agentic systems. It includes a framework, runtime, streaming engine, and memory store for creating any kind of agentic system: AI, autonomous, real-time, adaptive, transactional, analytical, or edge. The Akka Runtime is the most widely adopted actor-based runtime in the world, enabling high-throughput, stateful services that are resilient, elastic and responsive. Akka runs on any infrastructure: public cloud, private cloud or on-premises.

## [Tutorials](getting-started/index.html)

**Start here**: a hands-on introduction, guiding you through your first steps.

- [Build your first agent](getting-started/author-your-first-service.html)
- [Build an AI multi-agent planner](getting-started/planner-agent/index.html)
- [Explore other sample applications](getting-started/samples.html)
- [Foundations for building transactional and agentic AI services](concepts/index.html)

## [Understanding](concepts/index.html)

**Foundational topics** that explain how Akka services are designed and behave.

- [Agentic AI concepts](concepts/concepts.html)
- [Distributed systems](concepts/distributed-systems.html)
- [Deployment model](concepts/deployment-model.html)
- [Development process](concepts/development-process.html)
- [AI agents](concepts/ai-agents.html)
- [Memory models](concepts/state-model.html)
- [Saga patterns](concepts/saga-patterns.html)
- [Multi-region operations](concepts/multi-region.html)

## [Developing](sdk/index.html)

**Implementation guidance** for key components and development patterns.

- [Orchestration](sdk/workflows.html)
- [Agents](sdk/agents.html)
- [Memory](sdk/event-sourced-entities.html)
- [Streaming](sdk/consuming-producing.html)
- [Set up your local dev environment](sdk/running-locally.html)

## [Operating](operations/index.html)

**Practical guidance** for deploying, observing and managing Akka services.

- [Install the Akka CLI](operations/cli/installation.html)
- [Deploy and manage services](operations/services/deploy-service.html)
- [View metrics](operations/observability-and-monitoring/metrics.html)
- [Configure message brokers](operations/projects/message-brokers.html)
- [CI/CD with GitHub Actions](operations/integrating-cicd/github-actions.html)

## [Reference](reference/index.html)

**Technical reference material** for releases, APIs, tooling and terminology.

- [Release notes](reference/release-notes.html)
- [API documentation](reference/api-docs.html)
- [CLI command reference](reference/cli/akka-cli/index.html)
- [Glossary](reference/glossary.html)

## [Akka Libraries](libraries/index.html)

Akka provides a set of libraries for building and running responsive applications that have been used in production for over a decade.

<!-- <footer> -->
<!-- <nav> -->
[Getting started](getting-started/starthere.html)
<!-- </nav> -->

<!-- </footer> -->

<!-- <aside> -->

<!-- </aside> -->